@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    Idea-Codes
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> Idea-Codes</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> Idea-Codes</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="card-body">
        <div class="card-body">
            <div class="tab nav-border">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                            role="tab" aria-controls="home-02" aria-selected="true">Contract Pay Items Tracking </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02" role="tab"
                            aria-controls="profile-02" aria-selected="false">2025 Contract</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-03" role="tab"
                            aria-controls="profile-03" aria-selected="false">2026 Contract</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane fade active show" id="home-02" role="tabpanel" aria-labelledby="home-02-tab">
                        {{-- Main --}}
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Item Name</th>
                                        <th>Opration</th>
                                        <th>Quantity</th>
                                        <th>budget</th>
                                        <th>Cost</th>
                                        <th>Unit</th>
                                    </tr>
                                </thead>
                                <tboby>
                                    @foreach ($labs as $index => $lab)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $lab->desc }}</td>
                                            <td>
                                                <a href="{{ route('labs.show', encrypt($lab->id)) }}">
                                                    <button type="button" class="btn btn-success btn-sm"
                                                        data-toggle="modal" title=""><i class="fa fa-eye">Show
                                                            Item</i></button>
                                                </a>
                                                <button class="btn btn-danger btn-sm" data-toggle="modal"
                                                    data-target="#delete" data-id="{{ $lab->id }}"
                                                    title="{{ trans('Certificat_trans.Delete') }}"><i
                                                        class="fa fa-trash"></i></button>
                                                <button type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                                    data-target="#edit{{ $lab->id }}"
                                                    title="{{ trans('Depts_trans.Edit') }}"><i
                                                        class="fa fa-edit"></i></button>
                                            </td>
                                            <td>{{ $lab->qty }}</td>
                                            <td>{{ $lab->total }}</td>
                                            <td>{{ $lab->cost }}</td>
                                            <td>{{ $lab->unit->name }}</td>
                                        </tr>
                                        <!-- Edit_modal_Subject -->
                                        <div class="modal fade" id="edit{{ $lab->id }}" tabindex="-1"
                                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 style="font-family: 'Cairo', sans-serif;"
                                                            class="modal-title" id="exampleModalLabel">
                                                            Edit Item
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <!-- add_form -->
                                                        {!! Form::model($lab, ['route' => ['labs.update', $lab->id], 'method' => 'PUT']) !!}
                                                        @csrf
                                                        <div class="row">
                                                            <div class="col">
                                                                <label for="Name" class="mr-sm-2">Name :</label>
                                                                <input id="Name" type="text" name="desc"
                                                                    class="form-control" value="{{ $lab->desc }}"
                                                                    required>
                                                                <input id="id" type="hidden" name="id"
                                                                    class="form-control" value="{{ $lab->id }}">
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col">
                                                                <label for="Name" class="mr-sm-2">Quantity
                                                                    :</label>
                                                                <input id="Name" type="text" name="qty"
                                                                    class="form-control" value="{{ $lab->qty }}"
                                                                    required>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col">
                                                                <label for="Name" class="mr-sm-2">Budget :</label>
                                                                <input id="Name" type="text" name="budget"
                                                                    class="form-control" value="{{ $lab->budget }}"
                                                                    required>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col">
                                                                <label for="Name" class="mr-sm-2">Unit :</label>
                                                                <select name="unit_id" class="custom-select"
                                                                    aria-label="Default select example">
                                                                    @foreach ($units as $unit)
                                                                        <option
                                                                            value='{{ $unit->id }}'{{ $unit->name == $lab->unit_id ? 'selected' : '' }}>
                                                                            {{ $unit->name }}</option>
                                                                    @endforeach

                                                                </select>
                                                            </div>
                                                        </div>
                                                        <br><br>

                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                                                            <button type="submit"
                                                                class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                                                        </div>
                                                        {!! Form::close() !!}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- delete_modal_Subject -->
                                        <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 style="font-family: 'Cairo', sans-serif;"
                                                            class="modal-title" id="exampleModalLabel">
                                                            Delete Item
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        {!! Form::open(['route' => ['labs.destroy', $lab->id], 'method' => 'DELETE']) !!}
                                                        {{ method_field('Delete') }}
                                                        @csrf
                                                        {{ trans('Certificat_trans.Warning_certificat') }}
                                                        <input id="id" type="hidden" name="id"
                                                            class="form-control">
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                            <button type="submit"
                                                                class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                        </div>
                                                        {!! Form::close() !!}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tboby>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="profile-02" role="tabpanel" aria-labelledby="profile-02-tab">
                        {{-- 2025 --}}
                        <div class="card card-statistics">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered p-0">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Item Name</th>
                                                <th>Opration</th>
                                                <th>Quantity</th>
                                                <th>budget</th>
                                                <th>Acual</th>
                                                <th>Balance</th>
                                            </tr>
                                        </thead>
                                        <tboby>
                                            @foreach ($l1abs as $index => $lab)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $lab->desc }}</td>
                                                    <td>
                                                        <a href="{{ route('labs.show', encrypt($lab->id)) }}">
                                                            <button type="button" class="btn btn-success btn-sm"
                                                                data-toggle="modal" title=""><i
                                                                    class="fa fa-eye">Show
                                                                    Item</i></button>
                                                        </a>

                                                        <button class="btn btn-danger btn-sm" data-toggle="modal"
                                                            data-target="#delete" data-id="{{ $lab->id }}"
                                                            title="{{ trans('Certificat_trans.Delete') }}"><i
                                                                class="fa fa-trash"></i></button>

                                                        <button type="button" class="btn btn-info btn-sm"
                                                            data-toggle="modal"
                                                            data-target="#edit{{ $lab->id }}"
                                                            title="{{ trans('Depts_trans.Edit') }}"><i
                                                                class="fa fa-edit"></i></button>

                                                    </td>
                                                    <td>{{ $lab->qty }}</td>
                                                    <td>{{ $lab->total }}</td>
                                                    <td>{{ $lab->execute }}</td>
                                                    <td>{{ $lab->balance }}</td>
                                                </tr>
                                                <!-- Edit_modal_Subject -->
                                                <div class="modal fade" id="edit{{ $lab->id }}" tabindex="-1"
                                                    role="dialog" aria-labelledby="exampleModalLabel"
                                                    aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 style="font-family: 'Cairo', sans-serif;"
                                                                    class="modal-title" id="exampleModalLabel">
                                                                    Edit Item
                                                                </h5>
                                                                <button type="button" class="close"
                                                                    data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <!-- add_form -->
                                                                {!! Form::model($lab, ['route' => ['labs.update', $lab->id], 'method' => 'PUT']) !!}
                                                                @csrf
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <label for="Name" class="mr-sm-2">Name
                                                                            :</label>
                                                                        <input id="Name" type="text"
                                                                            name="desc" class="form-control"
                                                                            value="{{ $lab->desc }}" required>
                                                                        <input id="id" type="hidden"
                                                                            name="id" class="form-control"
                                                                            value="{{ $lab->id }}">
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <label for="Name" class="mr-sm-2">Quantity
                                                                            :</label>
                                                                        <input id="Name" type="text"
                                                                            name="qty" class="form-control"
                                                                            value="{{ $lab->qty }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <label for="Name" class="mr-sm-2">Budget
                                                                            :</label>
                                                                        <input id="Name" type="text"
                                                                            name="budget" class="form-control"
                                                                            value="{{ $lab->budget }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <label for="Name" class="mr-sm-2">Unit
                                                                            :</label>
                                                                        <select name="unit_id" class="custom-select"
                                                                            aria-label="Default select example">
                                                                            @foreach ($units as $unit)
                                                                                <option
                                                                                    value='{{ $unit->id }}'{{ $unit->name == $lab->unit_id ? 'selected' : '' }}>
                                                                                    {{ $unit->name }}</option>
                                                                            @endforeach

                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <br><br>

                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                                                                    <button type="submit"
                                                                        class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                                                                </div>
                                                                {!! Form::close() !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- delete_modal_Subject -->
                                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 style="font-family: 'Cairo', sans-serif;"
                                                                    class="modal-title" id="exampleModalLabel">
                                                                    Delete Item
                                                                </h5>
                                                                <button type="button" class="close"
                                                                    data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                {!! Form::open(['route' => ['labs.destroy', $lab->id], 'method' => 'DELETE']) !!}
                                                                {{ method_field('Delete') }}
                                                                @csrf
                                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                                <input id="id" type="hidden" name="id"
                                                                    class="form-control">
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                                    <button type="submit"
                                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                                </div>
                                                                {!! Form::close() !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </tboby>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="tab-pane fade" id="profile-03" role="tabpanel" aria-labelledby="profile-03-tab">
                        {{-- 2026 --}}
                        <div class="card card-statistics">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered p-0">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Item Name</th>
                                                <th>Opration</th>
                                                <th>Quantity</th>
                                                <th>budget</th>
                                                <th>Acual</th>
                                                <th>Balance</th>
                                            </tr>
                                        </thead>
                                        <tboby>
                                            @foreach ($l2abs as $index => $lab)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $lab->desc }}</td>
                                                    <td>
                                                        <a href="{{ route('labs.show', encrypt($lab->id)) }}">
                                                            <button type="button" class="btn btn-success btn-sm"
                                                                data-toggle="modal" title=""><i
                                                                    class="fa fa-eye">Show
                                                                    Item</i></button>
                                                        </a>

                                                        <button class="btn btn-danger btn-sm" data-toggle="modal"
                                                            data-target="#delete" data-id="{{ $lab->id }}"
                                                            title="{{ trans('Certificat_trans.Delete') }}"><i
                                                                class="fa fa-trash"></i></button>

                                                        <button type="button" class="btn btn-info btn-sm"
                                                            data-toggle="modal"
                                                            data-target="#edit{{ $lab->id }}"
                                                            title="{{ trans('Depts_trans.Edit') }}"><i
                                                                class="fa fa-edit"></i></button>

                                                    </td>
                                                    <td>{{ $lab->qty }}</td>
                                                    <td>{{ $lab->budget }}</td>
                                                    <td>{{ $lab->execute }}</td>
                                                    <td>{{ $lab->balance }}</td>
                                                </tr>
                                                <!-- Edit_modal_Subject -->
                                                <div class="modal fade" id="edit{{ $lab->id }}" tabindex="-1"
                                                    role="dialog" aria-labelledby="exampleModalLabel"
                                                    aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 style="font-family: 'Cairo', sans-serif;"
                                                                    class="modal-title" id="exampleModalLabel">
                                                                    Edit Item
                                                                </h5>
                                                                <button type="button" class="close"
                                                                    data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <!-- add_form -->
                                                                {!! Form::model($lab, ['route' => ['labs.update', $lab->id], 'method' => 'PUT']) !!}
                                                                @csrf
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <label for="Name" class="mr-sm-2">Name
                                                                            :</label>
                                                                        <input id="Name" type="text"
                                                                            name="desc" class="form-control"
                                                                            value="{{ $lab->desc }}" required>
                                                                        <input id="id" type="hidden"
                                                                            name="id" class="form-control"
                                                                            value="{{ $lab->id }}">
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <label for="Name" class="mr-sm-2">Quantity
                                                                            :</label>
                                                                        <input id="Name" type="text"
                                                                            name="qty" class="form-control"
                                                                            value="{{ $lab->qty }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <label for="Name" class="mr-sm-2">Budget
                                                                            :</label>
                                                                        <input id="Name" type="text"
                                                                            name="budget" class="form-control"
                                                                            value="{{ $lab->budget }}" required>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <label for="Name" class="mr-sm-2">Unit
                                                                            :</label>
                                                                        <select name="unit_id" class="custom-select"
                                                                            aria-label="Default select example">
                                                                            @foreach ($units as $unit)
                                                                                <option
                                                                                    value='{{ $unit->id }}'{{ $unit->name == $lab->unit_id ? 'selected' : '' }}>
                                                                                    {{ $unit->name }}</option>
                                                                            @endforeach

                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <br><br>

                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                                                                    <button type="submit"
                                                                        class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                                                                </div>
                                                                {!! Form::close() !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- delete_modal_Subject -->
                                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 style="font-family: 'Cairo', sans-serif;"
                                                                    class="modal-title" id="exampleModalLabel">
                                                                    Delete Item
                                                                </h5>
                                                                <button type="button" class="close"
                                                                    data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                {!! Form::open(['route' => ['labs.destroy', $lab->id], 'method' => 'DELETE']) !!}
                                                                {{ method_field('Delete') }}
                                                                @csrf
                                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                                <input id="id" type="hidden" name="id"
                                                                    class="form-control">
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                                    <button type="submit"
                                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                                </div>
                                                                {!! Form::close() !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </tboby>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject -->
</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);

    })
</script>

@toastr_js
@toastr_render
@endsection
