@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
    Idea - Payments
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    Payments
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> Payments</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#"
                        class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> Add Payments</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <a href="{{ route('payments.index') }}">
            <button type="button" class="btn btn-primary l-t-20">
                {{ trans('main_trans.back') }}
            </button>
        </a>
        <br><br>
        <div class="card card-statistics h-100">
            <div class="card-body">
                <div class="card-body">
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02" aria-selected="true">2025 Contract
                                </a>
                            </li>
                            @can('isAdmin')
                                <li class="nav-item">
                                    <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02"
                                        role="tab" aria-controls="profile-02" aria-selected="false">2026 Contract</a>
                                </li>
                            @endcan
                        </ul>
                        <div class="tab-content">
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            {{-- 2025 --}}
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">

                                {!! Form::open(['route' => 'payments.store', 'autocomplete' => 'off', 'files' => 'ture']) !!}

                                @csrf

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Item name : <span class="text-danger">*</span></label>
                                            <select name="lab" id="lab" class="custom-select"
                                                class="custom-select" aria-label="Default select example">
                                                <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                                @foreach ($labs as $key => $value)
                                                    <option value="{{ $key }}">{{ $value }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label>Code name : <span class="text-danger">*</span></label>
                                            <select name="code" id="code" class="custom-select"
                                                class="custom-select" aria-label="Default select example">
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label>Amount : <span class="text-danger">*</span></label>
                                            <input class="form-control" name="amount" type="number"
                                                value="{{ old('amount') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label>Quantity : <span class="text-danger">*</span></label>
                                            <input class="form-control" name="qty" type="number"
                                                value="{{ old('qty') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label for="note">Note</label>
                                            <textarea name="note" class="form-control" rows="4"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <p class="text-danger">* File PDF </p>
                                <div class="row">

                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label for="file">File : <span class="text-danger">*</span></label>
                                            <input type="file" name="file" class="dropify" accept="pdf/*"
                                                data-height="70" />
                                        </div>
                                    </div>
                                </div><br>
                                <div class="d-flex justify-content-center">
                                    <button type="submit" class="btn btn-primary btn-lg"> Add Payment</button>
                                </div>
                                {!! Form::close() !!}

                            </div>
                            {{-- 2026 --}}
                            @can('isAdmin')
                                <div class="tab-pane fade" id="profile-02" role="tabpanel"
                                    aria-labelledby="profile-02-tab">
                                    {!! Form::open(['route' => 'payments.store', 'autocomplete' => 'off', 'files' => 'ture']) !!}

                                    @csrf

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Item name : <span class="text-danger">*</span></label>
                                                <select name="lab" id="lab" class="custom-select"
                                                    class="custom-select" aria-label="Default select example">
                                                    <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                                    @foreach ($labs as $key => $value)
                                                        <option value="{{ $key }}">{{ $value }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Code name : <span class="text-danger">*</span></label>
                                                <select name="code" id="code" class="custom-select"
                                                    class="custom-select" aria-label="Default select example">
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Amount : <span class="text-danger">*</span></label>
                                                <input class="form-control" name="amount" type="number"
                                                    value="{{ old('amount') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Quantity : <span class="text-danger">*</span></label>
                                                <input class="form-control" name="qty" type="number"
                                                    value="{{ old('qty') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label for="note">Note</label>
                                                <textarea name="note" class="form-control" rows="4"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-danger">* File PDF </p>
                                    <div class="row">

                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label for="file">File : <span class="text-danger">*</span></label>
                                                <input type="file" name="file" class="dropify" accept="pdf/*"
                                                    data-height="70" />
                                            </div>
                                        </div>
                                    </div><br>
                                    <div class="d-flex justify-content-center">
                                        <button type="submit" class="btn btn-primary btn-lg"> Add Payment</button>
                                    </div>
                                    {!! Form::close() !!}

                                </div>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
<script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
<!--Internal Fancy uploader js-->
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>

<script>
    $(document).ready(function() {

        $('select[name="lab"]').on('change', function() {

            var lab = $(this).val();

            if (lab) {

                $.ajax({
                    url: '/getcodes/' + lab,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        console.log(data);
                        $('select[name="code"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="code"]')
                                .append('<option value="' + key + '">' + value +
                                    '</option>');
                        });
                    }

                });

            } else {
                $('select[name="code"]').empty();
            }

        });
    });
</script>

@endsection
