@extends('layouts.master')
@section('css')
    @toastr_css

@section('title')
    Idea - Code Report
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    Payments
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> Monthly Code Report</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> Monthly Code Report</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb Monthly Code Repor -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="datatable" class="table mg-b-0 text-md-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Code Name</th>
                                <th>Month</th>
                                <th>Exceute</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($codes as $index => $data)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $data->code->name }}</td>
                                    <td>{{ date('F', mktime(0, 0, 0, $data->month, 10)) }}</td>
                                    <td>{{ $data->total_amount }}</td>
                                </tr>
                            @endforeach
                        </tboby>
                    </table>
                    <br><br><br><br><br><br><br><br><br>
                </div>

            </div>
        </div>
    </div>
</div>
<!-- row closed -->
@endsection
@section('js')

@endsection
