@extends('layouts.master')
@section('css')

@section('title')
    Idea - Code Report
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> Code Report</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> Code Report</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <a href="{{ url('getcodesid') }}">
            <button type="button" class="btn btn-primary l-t-20">
                {{ trans('main_trans.back') }}
            </button>
            <br><br>
        </a>
        <div class="card card-statistics h-100">
            <div class="card-body">
                <!-- Item Details Table -->
                <div class="card mb-5">
                    <h3> {{ $code->name }}</h3>
                </div>

                <!-- Item Codes Table -->
                <div class="card">
                    <div class="card-header bg-success text-white text-center">Codes Payments</div>
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Quantity</th>
                                        <th>Amount</th>
                                        <th>Date</th>
                                        <th>Note</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($codes as $index => $code)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $code->qty }} </td>
                                            <td>{{ $code->amount }}</td>
                                            <td>{{ $code->created_at }}</td>
                                            <td>{{ $code->note }}</td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                            <br><br><br><br><br><br><br><br><br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- row closed -->
@endsection
@section('js')

@endsection
