@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Certificat_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
{{ trans('Certificat_trans.title_page') }} 
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Certificat_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Certificat_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <a href="{{ route('certificats.index') }}">
                <button type="button" class="btn btn-primary l-t-20">
                    {{ trans('main_trans.back') }}
                </button>
            </a>
            <br><br>
            <div class="card card-statistics h-100">
                
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                        {{-- <form method="post"  action="{{ route('certificats.store') }}" autocomplete="off" files="ture"> --}}
                         {!! Form::open(['url' => 'studentfileupload', 'autocomplete' => 'off', 'files' => 'ture' ]) !!}   
                            @csrf

                            
                           
                            <p class="text-danger">* صيغة المرفقات: jpeg ,jpg , png </p>
                           
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="students">{{trans('Certificat_trans.school_certificat')}} : <h6>في حالة بدل الفاقد</h6> </label>
                                        <input type="file" name="students" class="dropify"
                                        accept=".xlsx,.xlx" data-height="70" />
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-center">
                                <button type="submit" class="btn btn-primary btn-lg">{{trans('Certificat_trans.submit')}}</button>
                            </div>
                            
                            {!! Form::close() !!}
                            
                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>

    <script>
        $(document).ready(function() {
    
            $('#en').hide();
            $('#ar').hide();
    
            $('input[type="checkbox"]').click(function() {
                if ($(this).attr('id') == 'lang1') {
                    $('#ar').show();
                } 
                else if ($(this).attr('id') == 'lang2')
                {
                    $('#en').show();
                }
               
            });
        });
    
    </script>

@endsection
