@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Students_trans.Student_details') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    {{ trans('Students_trans.Student_details') }}
@stop
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">
                <div class="card-body">
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02"
                                    aria-selected="true">{{ trans('Students_trans.Student_details') }}</a>
                            </li>

                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">
                                <table class="table table-striped table-hover" style="text-align:right">
                                    <tbody>
                                        <tr>
                                            <td scope="row">{{ trans('Users_trans.name') }}</td>
                                            <td>{{ $user->first_name }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Students_trans.email') }}</td>
                                            <td>{{ $user->email }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Students_trans.gender') }}</td>
                                            <td>{{ $user->dept->name }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Users_trans.user_type') }}</td>
                                            <td>
                                                @if ($user->user_type == 'admin')
                                                    {{ trans('Users_trans.admin') }}
                                                @else
                                                    {{ trans('Users_trans.user') }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Students_trans.phone') }}</td>
                                            <td>{{ $user->phone }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Verifications_trans.title_page') }}</td>
                                            <td>
                                                @if ($user->verifiecation == '0')
                                                    <span class="label text-info">
                                                        {{ trans('Statment_trans.processing') }}
                                                    </span>
                                                @elseif ($user->verifiecation == '1')
                                                    <span class="label text-success">
                                                        {{ trans('Statment_trans.complate') }}
                                                    </span>
                                                @else
                                                    <span class="label text-danger">
                                                        {{ trans('Statment_trans.reject') }}
                                                    </span>
                                                @endif
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row">{{ trans('Students_trans.academic_year') }}</th>
                                            <td>{{ $user->certificats }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>


                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- row closed -->
    @endsection
    @section('js')
        @toastr_js
        @toastr_render
    @endsection
