<?php $__env->startSection('css'); ?>
    <?php echo toastr_css(); ?>
<?php $__env->startSection('title'); ?>
    Idea - Payments
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> Idea - Payments</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color"><?php echo e(trans('main_trans.Dashboard')); ?></a>
                </li>
                <li class="breadcrumb-item active"> Idea - Payments</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>


                <a href="<?php echo e(route('payments.create')); ?>">
                    <button type="button" class="btn btn-primary l-t-20">
                        <?php echo e(trans('Certificat_trans.submit')); ?>

                    </button>
                    <br><br>
                </a>


                <div class="table-responsive">
                    <table id="datatable" class="table mg-b-0 text-md-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Code Name</th>
                                <th>Item Name</th>
                                <th>Category</th>
                                <th>Quantity</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Opration</th>
                            </tr>
                        </thead>
                        <tboby>
                            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>

                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($payment->code->name); ?></td>
                                    <td><?php echo e($payment->lab->name); ?></td>
                                    <td><?php echo e($payment->course->name); ?></td>
                                    <td><?php echo e($payment->qty); ?></td>
                                    <td><?php echo e($payment->amount); ?></td>
                                    <td><?php echo e($payment->created_at); ?></td>
                                    <td>

                                        <a href="<?php echo e(route('payments.edit', encrypt($payment->id))); ?>">
                                            <button type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                                title="<?php echo e(trans('Certificat_trans.Edit')); ?>"><i
                                                    class="fa fa-edit"></i></button>
                                        </a>

                                        <a href="<?php echo e(route('payments.show', encrypt($payment->id))); ?>">
                                            <button type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                title="<?php echo e(trans('Certificat_trans.show')); ?>"><i
                                                    class="fa fa-eye"></i></button>
                                        </a>

                                        <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete"
                                            data-id="<?php echo e($payment->id); ?>"
                                            title="<?php echo e(trans('Certificat_trans.Delete')); ?>"><i
                                                class="fa fa-trash"></i></button>

                                    </td>
                                </tr>


                                <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    <?php echo e(trans('Certificat_trans.delete_certificat')); ?>

                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <?php echo Form::open(['route' => ['payments.destroy', $payment->id], 'method' => 'DELETE']); ?>

                                                <?php echo e(method_field('Delete')); ?>

                                                <?php echo csrf_field(); ?>
                                                <?php echo e(trans('Certificat_trans.Warning_certificat')); ?>

                                                <input id="id" type="hidden" name="id"
                                                    class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal"><?php echo e(trans('Certificat_trans.Close')); ?></button>
                                                    <button type="submit"
                                                        class="btn btn-danger"><?php echo e(trans('Certificat_trans.Delete')); ?></button>
                                                </div>
                                                <?php echo Form::close(); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject
   
-->

</div>
<!-- row closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);

    })
</script>

<?php echo toastr_js(); ?>
<?php echo app('toastr')->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Mustafa\Certificates\resources\views/pages/Payments/index.blade.php ENDPATH**/ ?>